/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.DrillDownComposite;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.debug.ui.preferences.stepFilter.IncPathFile;
import org2.eclipse.php.internal.debug.ui.preferences.stepFilter.PHPResLabelProvider;
import org2.eclipse.php.internal.debug.ui.preferences.stepFilter.PHPResourceContentProvider;

public class PHPResourceSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private Object selectedResource;
    private PHPResourceContentProvider cp;
    TreeViewer treeViewer;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public PHPResourceSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects) {
        this(parent, listener, allowNewContainerName, message, showClosedProjects, 300, 320);
    }

    public PHPResourceSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, int heightHint, int widthHint) {
        super(parent, 0);
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.showClosedProjects = showClosedProjects;
        if (message != null) {
            this.createContents(message, heightHint, widthHint);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, heightHint, widthHint);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, heightHint, widthHint);
        }
    }

    public void resourceSelectionChanged(Object resource) {
        this.selectedResource = resource;
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300, 320);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.cp = new PHPResourceContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PHPResLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PHPResourceSelectionGroup.this.resourceSelectionChanged(selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (PHPResourceSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        PHPResourceSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        PHPResourceSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    void refreshResources() {
        this.treeViewer.refresh();
    }

    public IPath getPathForSelectedResource() {
        if (this.selectedResource == null) {
            return null;
        }
        IPath result = null;
        if (this.selectedResource instanceof IResource) {
            result = ((IResource)this.selectedResource).getFullPath();
        } else if (this.selectedResource instanceof IIncludePathEntry) {
            result = ((IIncludePathEntry)this.selectedResource).getPath();
        } else if (this.selectedResource instanceof IncPathFile) {
            result = new Path(((IncPathFile)this.selectedResource).file.getAbsolutePath());
        }
        return result;
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setSelectedResource(IResource resource) {
        this.selectedResource = resource;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = resource.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
    }
}

